% *************************************************************************
% 
%                      iGem Modelling - 2018
%                     Delft University of Technology
% 
% *************************************************************************
% 
%               Title
% 
%                    File: IV and IM Kinetic Equations
%                           
% 
%              
% *************************************************************************
function dy = dydt_IV_IM(t, y)
%Define components
cbl = y(1); %Concentration of viral vectors in blood (#/ml).
cti = y(2); %Concentration of viral vectors in tissue (#/ml).
vesicle = y(3); %Concentration of viral vectors in vesicles in the infected cells (#/ml).
complexintracell = y(4); %Concentration of viral vectors in the infected cells (#/ml).
plasmid = y(5); %Concentration of plasmids in the infected cells (#/ml).
plasmidbound = y(6); %Concentration of  bound plasmids in the infected cells (#/ml).
complexbound = y(7); %Concentration of  bound viral vectors in the infected cells (#/ml).
complexboundNPC = y(8); %Concentration of viral vectors bound to NPCs in the infected cells (#/ml)
complexboundnucleus = y(9); %Concentration of bound viral vectors in the nucleus of infected cells (#/ml).
complexnucleus = y(10); %Concentration of viral vectors in the nucleus of infected cells (#/ml).
plasmidboundNPC = y(11); %Concentration of plasmids bound to NPCs in the infected cells (#/ml)
plasmidboundnucleus = y(12); %Concentration of bound plasmids in the nucleus of infected cells(#/ml)
plasmidnucleus = y(13); %Concentration of plasmids in the nucleus of infected cells(#/ml)
protein = y(14); %Concentration of doping EPO protein inside of infected cells(#/ml)
proteinextra = y(15); %Concentration of doping EPO protein outside of infected cells(#/ml)
cfDNA = y(16); %Concentration of doping DNA in the blood(#/ml)
cmus = y(17);  %Concentration of viral vectors in muscle (#/ml).


%Define rate constants
%vector:Ad5 
%Units: (day^-1)

kbl= 1440; % Vector displacement from blood to tissue                    
kti= 1440; % Vector displacement from tissue to blood 
kel_bl=720; % Elimination of viral vectors from the blood 
kel_mus = 720; % Elimination of viral vectors from the muscle 
kmus=1440; % Vector displacement from muscle to blood 
kbinduptake= 8.64; %Endosomal uptake 
kescape=23.04; % Complex movement from endosome to intracellular 
kdegvesicle=28.8; % Degradation of complex within uptake vesicle 
kunpack=14.4; kunpack2=14.4; %Plasmid detaches from vector either in cytoplasm(1) or in the nucleus(2)
kdeg=7.2; % Degradation of unbound plasmid in the cytoplasm 
kbindvector=144; %Binding of gene delivery vector to compound targeting for the nucleus 
kbindplasmid=2.88; % Binding of plasmid to compound targeting for the nucleus 
kNPC=1.44*10^6; % Binding formed complexes to Nuclear Pore Complex 
kin=4.32;kin2=4.32; % Uptake nucleus through Nuclear Pore Complex 
kdissociation=1.44*10^6;kdissociation2=1.44*10^6; % Dissociation from the NPC targeting compound 
kprotein=14.4; %Protein production from plasmid
kdegprot=25/24.; %Cytoplasmic degradation of the protein
kexport=1.44*10^6; %Export of EPO protein to extracellular environment
kdegprotextra=25/24.; %Degradation of EPO protein in blood
kcelldeath=	0.0167; % Average death rate of renal interstitial fibroblast
kel2= 100; %Clearance of cfDNA from the blood

%Write rate equations
dy(1) = -(kbl+kel_bl)*cbl+kti*cti + kmus*cmus; 
dy(2) = kbl*cbl-(kbinduptake+kti)*cti; 
dy(3) = kbinduptake*cti - kescape*vesicle - kdegvesicle*vesicle;
dy(4) = kescape*vesicle-kunpack*complexintracell-kbindvector*complexintracell;
dy(5) = kunpack*complexintracell - kbindplasmid*plasmid - kdeg*plasmid;
dy(6) = kbindplasmid*plasmid - kNPC*plasmidbound;
dy(7) = kbindvector*complexintracell - kNPC*complexbound;
dy(8) = kNPC*complexbound - kin*complexboundNPC;
dy(9) = kin*complexboundNPC - kdissociation*complexboundnucleus;
dy(10) = kdissociation*complexboundnucleus - kunpack2*complexnucleus;
dy(11) = kNPC*plasmidbound - kin2*plasmidboundNPC;
dy(12) = kin2*plasmidboundNPC - kdissociation2*plasmidboundnucleus;
dy(13) = kdissociation2*plasmidboundnucleus + kunpack2*complexnucleus - kcelldeath*plasmidnucleus;%once safely in nucleus, no degradation and therefore from this perspective stable production.However, cells die, leading to less nuclei with the plasmids overall.
dy(14) = kprotein*plasmidnucleus - kdegprot*protein - kexport*protein;
dy(15) = kexport*protein - kdegprotextra*proteinextra;
dy(16) = kcelldeath*plasmidnucleus - kel2*cfDNA;
dy(17) = -(kmus+kel_mus)*cmus;
dy=dy';
end

